USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_RecordUserSpendingPoints]    Script Date: 8/27/2013 2:33:14 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-29>
-- Description:	<Record user spending points>
-- =============================================
CREATE PROCEDURE [dbo].[RP_RecordUserSpendingPoints]
	@userID int, @amount money, @orderID int, @errorMessage varchar(max) OUTPUT 
AS
DECLARE @returnCode int = 1, @fullMatchingRecordID int, @semiMatchingRecordID int, @orderMatchingRecordID int, @userCurrentPointsTotal money
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be non-committable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';

	-- just make sure it is negative
	SET @amount = (-1)*SIGN(@amount)*@amount;

	-- look for a matching record, if there is one return already exist or something
	SELECT @fullMatchingRecordID = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and PointChange = @amount and Type = 5);
	SELECT @semiMatchingRecordID = (SELECT ID FROM [dbo].[RewardTransaction] WHERE UserID = @userID and OrderID = @orderID and PointChange != @amount and Type = 5);
	SELECT @orderMatchingRecordID = (SELECT ID FROM [dbo].[RewardTransaction] WHERE OrderID = @orderID and Type = 5);

	-- make sure user has enought points to spend
	EXEC [dbo].[RP_GetUserRewardPointsTotal]
		@UserID = @UserID,
		@userTotalPoints = @userCurrentPointsTotal OUTPUT;

	IF @userCurrentPointsTotal < @amount*(-1) 
		BEGIN
		SELECT @returnCode = 300;
		--print 'NOPE not enough iskies';
		SELECT @errorMessage = 'User does not have enough points';
		END;
	ELSE IF @fullMatchingRecordID IS NOT NULL
		BEGIN
		SELECT @returnCode = 301;
		--print 'NOPE its been done already';
		SELECT @errorMessage = 'Order already completed';
		END;
	ELSE IF @semiMatchingRecordID IS NOT NULL
		BEGIN
		SELECT @returnCode = 302;
		--print 'NOPE Order number used already but different amount';
		SELECT @errorMessage = 'Order already completed with different amount';
		END;
	ELSE IF @orderMatchingRecordID IS NOT NULL
		BEGIN
		SELECT @returnCode = 303;
		--print 'NOPE Order number used already but different amount';
		SELECT @errorMessage = 'Order already completed with different user';
		END;
	ELSE 
	BEGIN
		BEGIN TRY
			BEGIN TRANSACTION;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
				INSERT INTO [dbo].[RewardTransaction] 
				(UserID
				,OrderID
				,DateCreated
				,PointChange
				,Type)
				Values
				(@userID
				,@orderID
				,GETUTCDATE()
				,@amount
				,5);
			COMMIT TRANSACTION;
		END TRY
		BEGIN CATCH
			ROLLBACK TRANSACTION;
			SELECT @returnCode = 900;
			--PRINT ERROR_MESSAGE();
			SELECT @errorMessage = ERROR_MESSAGE();
		END CATCH;
	END;
	RETURN @returnCode    

END

GO


